/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.tabbedPane;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JToggleButton;

class VWTabButton
extends JToggleButton {
    protected static final Color COLOR_NORMAL = Color.GRAY;
    protected static final Color COLOR_SELECTED = Color.BLACK;
    protected static final Color BGCOLOR_LTGRAY = new Color(220, 221, 222);
    protected int m_nType = 0;

    public VWTabButton(String title, int nType) {
        super(title);
        FontMetrics fm;
        this.m_nType = nType;
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        if (nType == 1) {
            this.setMargin(new Insets(10, 5, 10, 5));
        } else {
            this.setMargin(new Insets(1, 5, 1, 5));
        }
        Font font = super.getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            int nLength = fm.stringWidth(title);
            Insets insets = this.getInsets();
            int nWidth = nLength + (insets.left + insets.right) * 2;
            Dimension newSize = this.getPreferredSize();
            if (newSize.width < nWidth) {
                newSize.width = nWidth;
            }
            this.setPreferredSize(newSize);
        }
    }

    public Font getFont() {
        Font aFont = super.getFont();
        if (aFont == null || this.model.isArmed() && this.model.isPressed() || this.model.isSelected()) {
            return aFont;
        }
        return new Font(aFont.getName(), 0, aFont.getSize());
    }

    public void paint(Graphics g) {
        Color oldColor = g.getColor();
        Dimension size = this.getSize();
        if (!(this.m_nType != 0 || this.model.isArmed() && this.model.isPressed() || this.model.isSelected())) {
            g.setColor(BGCOLOR_LTGRAY);
            g.fillRect(1, 1, size.width - 1, size.height - 1);
        }
        super.paint(g);
        switch (this.m_nType) {
            case 0: {
                if (this.model.isArmed() && this.model.isPressed() || this.model.isSelected()) {
                    g.setColor(COLOR_SELECTED);
                    g.drawLine(0, size.height, 0, 1);
                    g.drawLine(1, 0, size.width - 2, 0);
                    g.drawLine(size.width - 1, 1, size.width - 1, size.height);
                    break;
                }
                g.setColor(COLOR_NORMAL);
                g.drawLine(0, 1, size.width - 2, 1);
                g.drawLine(size.width - 1, 2, size.width - 1, size.height);
                g.setColor(COLOR_SELECTED);
                g.drawLine(0, size.height - 1, size.width, size.height - 1);
            }
        }
        g.setColor(oldColor);
    }
}

